% STATISTICAL ANALYSES:
% ---------------------

%manualKMselection = zeros(loops,2);
% Do clinical statistics and record results in file
fid = fopen([plots_dir '_statistical_results.txt'], 'w+');
colorfile = fopen([plots_dir 'colors.txt'], 'w+');
for i=1:loops
    nr_of_components = agreement_results(i).nr_of_components;
    sample_to_component = agreement_results(i).sample_to_component;
    pixel_to_component = agreement_results(i).pixel_to_component;
    colsel = agreement_results(i).colsel;
    component_spectra = agreement_results(i).component_spectra;
    classplot = insertdummyspectra(pixel_to_component, agreement_results(i).goodlist);
    nr_comps = length(unique(pixel_to_component));
    goodlist = agreement_results(i).goodlist;
    
    % create R colormap
    colstr = 'c(';
    for v=1:nr_comps
        colstr = [colstr 'rgb(' sprintf('%s,%s,%s',num2str(colmap(colsel(v),1)),num2str(colmap(colsel(v),2)),num2str(colmap(colsel(v),3))), '),'];
        if(v == nr_comps)
            colstr(end) = ')';
        end
    end
    fprintf(colorfile, [date ' >> Number of components:\tn=\t%1.1f\n' colstr '\n'], nr_comps);
    
    %statistical_analyses_breastcancer;
    statistical_analyses_gastric_cancer;
    %statistical_analyses_sha_sts;
    %statistical_analyses_meding;
    %phylogenetic_analyses;
end
fclose(colorfile);
fclose(fid);

logger;
% clearvars -except AICc agreement_results classes clustering_evaluation_values colmap complete_image_cube he_image image_cube image_data markerlist master_peak_list2 median_image my ref_peaks region_overview sample_data tic_image x y
%save([plots_dir 'analyzed data.mat']);